%% Plot trade-offs (Fig 9) in Small et al. "A thinner than present West
% Antarctic Ice Sheet in the southern Weddell Sea Embayment during the
% Holocene"

load fitting_model_results_BH02_22-Sep-2025_10000_95_10_fix_RMSE.mat % load fitting results

% define core being plotted
core = 2;

% Plots duration of exposure/lowstand against (any) residual ice thickness (Figure X in paper)
plot_tradeoffs(results); 

% and save as PNG
if core == 2
    name = 'BH02';
elseif core == 3 
    name = 'BH03';
else 
    name = 'BH06';
end

save_name = strcat(name,' trade offs_RMSE');
print(save_name,'-dpng','-r300')